<?php
	include("inc/init.php");
	$blog = db_array("SELECT * FROM `".$db_left."_blog` WHERE `id` = 1");
	$posts = db_arrays("SELECT * FROM `".$db_left."_posts` ");
	$category = db_arrays("SELECT * FROM `".$db_left."_category` ");
	$comment = db_arrays("SELECT * FROM `".$db_left."_comment`");
	switch($database_type)
	{
		case 'sqlite':
			db_query("vacuum `".$db_left."_blog`");
			db_query("vacuum `".$db_left."_posts`");
			db_query("vacuum `".$db_left."_category`");
			db_query("vacuum `".$db_left."_comment`");
			db_query("DROP TABLE `".$db_left."_blog`;");
			db_query("CREATE TABLE  `".$db_left."_blog` (  `id` INTEGER  PRIMARY KEY AUTOINCREMENT,  `name` varchar(255) ,  `author` varchar(60) ,  `title` varchar(255) ,  `keywords` text ,  `description` varchar(255) ,  `database_type` varchar(20),  `db_url` varchar(255) ,  `db_port` int(10) ,  `db_name` varchar(80) ,  `db_username` varchar(128) ,  `db_passwd` char(32) ,  `db_left` varchar(20) ,  `admin` varchar(128) ,  `passwd` char(32) ,  `close` tinyint(1) ,  `close_tip` text ,  `cache` tinyint(1) ,  `cache_expired` int(10) ,  `user_track` tinyint(1) ,  `url_rewrite` tinyint(1) ,  `logo` varchar(255) ,  `theme` varchar(255) ,  `lang` varchar(80) ,  `admin_email` varchar(255)) ;");
			db_query("DROP TABLE `".$db_left."_posts`;");
			db_query("CREATE TABLE  `".$db_left."_posts` (  `id` INTEGER  PRIMARY KEY AUTOINCREMENT,  `name` varchar(256) ,  `title` varchar(256) ,  `body` longtext ,  `keyword` varchar(255)  default '',  `tags` text ,  `description` varchar(255)  default '',  `sys_name` varchar(128) UNIQUE,  `date` int(10)  default '0',  `category` int(10)  default '0',  `in_blog` tinyint(1) ,  `top_home` tinyint(1)  default '0',  `views` int(10) ,  `allow_comment` tinyint(1)  default '1',  `template` varchar(60)) ;");
			db_query("DROP TABLE `".$db_left."_comment`;");
			db_query("CREATE TABLE  `".$db_left."_comment` (  `id` INTEGER  PRIMARY KEY AUTOINCREMENT,  `umail` varchar(255)  default '',  `url` text  ,  `info` text ,  `post_id` INTEGER  default '0',  `post_name` varchar(255) ,  `post_url` text ,  `date` int(10)  default '0',  `ip` varchar(15)  default '',  `show` tinyint(1)  default '0') ;");
			db_query("DROP TABLE `".$db_left."_category`;");
			db_query("CREATE TABLE  `".$db_left."_category` (  `id` INTEGER  PRIMARY KEY AUTOINCREMENT,  `name` varchar(256) ,  `link` varchar(128) UNIQUE,  `title` text ,  `description` varchar(255) ,  `keyword` varchar(255) ,  `sort_word` text ,  `parent_id` int(10)  default '0',  `template` varchar(60)) ;");
			db_query("vacuum `".$db_left."_blog`");
			db_query("vacuum `".$db_left."_posts`");
			db_query("vacuum `".$db_left."_category`");
			db_query("vacuum `".$db_left."_comment`");
		break;
		case 'pgsql':
			db_query("vacuum analyze `".$db_left."_blog`");
			db_query("vacuum analyze `".$db_left."_posts`");
			db_query("vacuum analyze `".$db_left."_category`");
			db_query("vacuum analyze `".$db_left."_comment`");
			db_query("DROP TABLE \"".$db_left."_blog\";");
			db_query("CREATE TABLE  \"".$db_left."_blog\" (  \"id\" serial,  \"name\" varchar(255) NOT NULL,  \"author\" varchar(60) NOT NULL,  \"title\" varchar(255) NOT NULL,  \"keywords\" text NOT NULL,  \"description\" varchar(255) NOT NULL,  \"database_type\" varchar(20) NOT NULL,  \"db_url\" varchar(255) NOT NULL,  \"db_port\" int NOT NULL,  \"db_name\" varchar(80) NOT NULL,  \"db_username\" varchar(128) NOT NULL,  \"db_passwd\" varchar(128) NOT NULL,  \"db_left\" varchar(20) NOT NULL,  \"admin\" varchar(128) NOT NULL,  \"passwd\" char(32) NOT NULL,  \"close\" int NOT NULL,  \"close_tip\" text NOT NULL,  \"cache\" int NOT NULL,  \"cache_expired\" int NOT NULL,  \"user_track\" int NOT NULL,  \"url_rewrite\" int NOT NULL,  \"logo\" varchar(255) NOT NULL,  \"theme\" varchar(255) NOT NULL,  \"lang\" varchar(80) NOT NULL,  \"admin_email\" varchar(255) NOT NULL,  PRIMARY KEY  (\"id\"));");
			db_query("DROP TABLE \"".$db_left."_posts\";");
			db_query("CREATE TABLE  \"".$db_left."_posts\" (  \"id\" serial,  \"name\" varchar(256) NOT NULL,  \"title\" varchar(256) NOT NULL,  \"body\" text NOT NULL,  \"keyword\" varchar(255) NOT NULL default '',  \"tags\" text NOT NULL,  \"description\" varchar(255) NOT NULL default '',  \"sys_name\" varchar(128) NOT NULL UNIQUE,  \"date\" int NOT NULL default '0',  \"category\" int NOT NULL default '0',  \"in_blog\" int NOT NULL,  \"top_home\" int NOT NULL default '0',  \"views\" int NOT NULL,  \"allow_comment\" int NOT NULL default '1', \"template\" varchar(60) NOT NULL , PRIMARY KEY  (\"id\"));");
			db_query("DROP TABLE \"".$db_left."_comment\";");
			db_query("CREATE TABLE  \"".$db_left."_comment\" (  \"id\" serial,  \"umail\" varchar(255) NOT NULL default '',  \"url\" text NOT NULL ,  \"info\" text NOT NULL,  \"post_id\" int NOT NULL default '0',  \"post_name\" varchar(255) NOT NULL,  \"post_url\" text NOT NULL,  \"date\" int NOT NULL default '0',  \"ip\" varchar(15) NOT NULL default '',  \"show\" int NOT NULL default '0',  PRIMARY KEY  (\"id\"));");
			db_query("DROP TABLE \"".$db_left."_category\";");
			db_query("CREATE TABLE  \"".$db_left."_category\" (  \"id\" serial,  \"name\" varchar(256) NOT NULL,  \"link\" varchar(128) NOT NULL UNIQUE,  \"title\" text NOT NULL,  \"description\" varchar(255) NOT NULL,  \"keyword\" varchar(255) NOT NULL,  \"sort_word\" text NOT NULL,  \"parent_id\" int NOT NULL default '0',  \"template\" varchar(60) NOT NULL,  PRIMARY KEY  (\"id\"));");
			db_query("vacuum analyze `".$db_left."_blog`");
			db_query("vacuum analyze `".$db_left."_posts`");
			db_query("vacuum analyze `".$db_left."_category`");
			db_query("vacuum analyze `".$db_left."_comment`");
		break;
		case 'mysql':
			db_query("optimize table `".$db_left."_blog`");
			db_query("optimize table `".$db_left."_posts`");
			db_query("optimize table `".$db_left."_category`");
			db_query("optimize table `".$db_left."_comment`");
			db_query("DROP TABLE `".$db_left."_blog`;");
			db_query("CREATE TABLE `".$db_left."_blog` (  `id` int(10) NOT NULL auto_increment,  `name` varchar(255) NOT NULL,  `author` varchar(60) NOT NULL,  `title` varchar(255) NOT NULL,  `keywords` text NOT NULL,  `description` varchar(255) NOT NULL,  `database_type` varchar(20) NOT NULL,  `db_url` varchar(255) NOT NULL,  `db_port` int(10) ,  `db_name` varchar(80) NOT NULL,  `db_username` varchar(128) NOT NULL,  `db_passwd` char(32) NOT NULL,  `db_left` varchar(20) NOT NULL,  `admin` varchar(128) NOT NULL,  `passwd` char(32) NOT NULL,  `close` tinyint(1) NOT NULL,  `close_tip` text NOT NULL,  `cache` tinyint(1) ,  `cache_expired` int(10) ,  `user_track` tinyint(1) NOT NULL,  `url_rewrite` tinyint(1) NOT NULL,  `logo` varchar(255) NOT NULL,  `theme` varchar(255) NOT NULL,  `lang` varchar(80) NOT NULL,  `admin_email` varchar(255) NOT NULL,  PRIMARY KEY  (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;");
			db_query("DROP TABLE `".$db_left."_posts`;");
			db_query("CREATE TABLE `".$db_left."_posts` (  `id` int(10) NOT NULL auto_increment,  `name` varchar(256) NOT NULL,  `title` varchar(256) NOT NULL,  `body` longtext NOT NULL,  `keyword` varchar(255) NOT NULL default '',  `tags` text NOT NULL,  `description` varchar(255) NOT NULL default '',  `sys_name` varchar(128) NOT NULL,  `date` int(10) NOT NULL default '0',  `category` int(10) NOT NULL default '0',  `in_blog` tinyint(1) NOT NULL,  `top_home` tinyint(1) NOT NULL default '0',  `views` int(10) NOT NULL,  `allow_comment` tinyint(1) NOT NULL default '1', `template` varchar(60) NOT NULL , PRIMARY KEY  (`id`),  UNIQUE KEY `sys_name` (`sys_name`),  KEY `date` (`date`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;");
			db_query("DROP TABLE `".$db_left."_comment`;");
			db_query("CREATE TABLE `".$db_left."_comment` (  `id` int(10) NOT NULL auto_increment,  `umail` varchar(255) NOT NULL default '',  `url` text NOT NULL ,  `info` text NOT NULL,  `post_id` int(10) NOT NULL default '0',  `post_name` varchar(255) NOT NULL,  `post_url` text NOT NULL,  `date` int(10) NOT NULL default '0',  `ip` varchar(15) NOT NULL default '',  `show` tinyint(1) NOT NULL default '0',  PRIMARY KEY  (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;");
			db_query("DROP TABLE `".$db_left."_category`;");
			db_query("CREATE TABLE `".$db_left."_category` (  `id` int(4) NOT NULL auto_increment,  `name` varchar(256) NOT NULL,  `link` varchar(128) NOT NULL,  `title` text NOT NULL,  `description` varchar(255) NOT NULL,  `keyword` varchar(255) NOT NULL,  `sort_word` text NOT NULL,  `parent_id` int(10) NOT NULL default '0',  `template` varchar(60) NOT NULL,  PRIMARY KEY  (`id`),  UNIQUE KEY `link` (`link`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;");
			db_query("optimize table `".$db_left."_blog`");
			db_query("optimize table `".$db_left."_posts`");
			db_query("optimize table `".$db_left."_category`");
			db_query("optimize table `".$db_left."_comment`");
		break;
	
	}

		db_insert($db_left."_blog",array('id',''),array('name' , 'author' ,'title' , 'keywords' , 'description' , 'database_type' , 'db_url' , 'db_port' ,'db_name' , 'db_username' , 'db_passwd' ,'db_left' , 'admin' , 'passwd','close' ,'close_tip','cache','cache_expired','user_track','url_rewrite','logo','theme','lang','admin_email'),array($blog["name"], $blog["author"], $blog["title"], $blog["keywords"], $blog["description"], $blog["database_type"] , $blog["db_url"], $blog["db_port"],$blog["db_name"], $blog["db_username"], $blog["db_passwd"],$blog["db_left"], $blog["admin"], $blog["passwd"],$blog["close"],$blog["close_tip"],$blog["cache"],$blog["cache_expired"],$blog["user_track"],$blog["url_rewrite"],$blog["logo"],$blog["theme"],$blog["lang"],$blog["admin_email"]));
		foreach($posts as $key=>$val)
		{
				switch($database_type)
				{
					case 'sqlite':
						foreach($val as $k=>$v)
						{
							$val[$k] = sqlite_escape_string($v);
						}
					break;
					case 'pgsql':
						foreach($val as $k=>$v)
						{
							$val[$k] = pg_escape_string($v);
						}
					break;
					case 'mysql':
						foreach($val as $k=>$v)
						{
							$val[$k] = mysql_escape_string($v);
						}
					break;
				}
				db_insert($db_left."_posts",array('id',$val['id']),array( 'name','title' , 'body' ,'keyword' ,'tags','description' , 'sys_name' ,'date' , 'category' ,'in_blog','top_home','views','allow_comment','template'),array($val['name']?$val['name']:$val['title'], $val['title'], $val['body'], $val['keyword'],$val['tags'],$val['description'],$val['sys_name'],$val['date'], $val['category'] ,$val['in_blog'],$val['top_home'],$val['views'],$val['allow_comment'],$val['template']));
		}
		foreach($comment as $key=>$val)
		{
				switch($database_type)
				{
					case 'sqlite':
						foreach($val as $k=>$v)
						{
							$val[$k] = sqlite_escape_string($v);
						}
					break;
					case 'pgsql':
						foreach($val as $k=>$v)
						{
							$val[$k] = pg_escape_string($v);
						}
					break;
					case 'mysql':
						foreach($val as $k=>$v)
						{
							$val[$k] = mysql_escape_string($v);
						}
					break;
				}
			db_insert($db_left."_comment",array('id',$val['id']),array('umail' ,'url',  'info' , 'post_id' , 'post_name' , 'post_url' ,'date' , 'ip' , 'show'),array($val['umail'],$val['url'],$val['info'], $val['post_id'], $val['post_name']?$val['post_name']:$val['post_title'], $val['post_url'],$val['date'] , $val['ip'], $val['show']));
		}
		foreach($category as $key=>$val)
		{
				switch($database_type)
				{
					case 'sqlite':
						foreach($val as $k=>$v)
						{
							$val[$k] = sqlite_escape_string($v);
						}
					break;
					case 'pgsql':
						foreach($val as $k=>$v)
						{
							$val[$k] = pg_escape_string($v);
						}
					break;
					case 'mysql':
						foreach($val as $k=>$v)
						{
							$val[$k] = mysql_escape_string($v);
						}
					break;
				}
			db_insert($db_left."_category",array('id',$val['id']),array('name' , 'link' , 'title' , 'description' , 'keyword' , 'sort_word','parent_id','template'),array($val['name'], $val['link'], $val['title'], $val['description'], $val['keyword'], $val['sort_word'], $val['parent_id'],''));
		}
			$rows = db_arrays("SELECT * FROM `".$db_left."_category`");
			$cat_str = '<?php'."\n";
			foreach($rows as $row)
			{
				$category[$row['id']] = $row;
				$cat_str .= '$cat_link["'.$row['id'].'"] = "'.$row['link'].'";'."\n";
				$cat_str .= '$cat_page["'.$row['id'].'"] = "'.$row['name'].'";'."\n";
				$cat_str .= '$cat_description["'.$row['id'].'"] = "'.$row['description'].'";'."\n";
				$cat_str .= '$cat_keyword["'.$row['id'].'"] = "'.$row['keyword'].'";'."\n";
				$cat_str .= '$cat_title["'.$row['id'].'"] = "'.$row['title'].'";'."\n";
				$cat_str .= '$cat_sort_word["'.$row['id'].'"] = "'.$row['sort_word'].'";'."\n";
				$cat_str .= '$cat_parent_id["'.$row['id'].'"] = "'.$row['parent_id'].'";'."\n";
				$cat_str .= '$cat_template["'.$row['id'].'"] = "'.$row['template'].'";'."\n";
			}
			$cat_str .= '?>';
			file_put_contents('inc/category.php',$cat_str);

		echo 'SweetRice\'s database upgrade from 0.5.x to 0.6.3 successfully.<br />you can remove this file now.<br />You may need remove the old database backups at "Dashboard->Data->Data Import" if the backups exists.';
		
?>