<?php
/**
 * Custom field template.
 *
 * @package SweetRice
 * @Dashboard core
 * @since 0.5.4
 */
 defined('VALID_INCLUDE') or die();
?>
<fieldset><legend class="toggle" data=".cfbody"><?php _e('Custom Field');?></legend>
<div class="cfbody<?php echo !count($cf_rows)?' hidden':'';?>">
<ol id="cfList">
<?php
	$no = 0;
	$cflist = array();
	foreach($cf_rows as $val){
		$no += 1;
		$cflist[$val['name']] = true;
?>
<li id="cf_<?php echo $no;?>">
<fieldset><legend><?php _e('Name');?> <input type="text" name="cfname[<?php echo $no;?>]" value="<?php echo $val['name'];?>"> 
<input type="button" value="<?php _e('Delete');?>" class="cf_del" data="<?php echo $no;?>"></legend>
<input type="hidden" name="cfid[<?php echo $no;?>]" value="<?php echo $val['id'];?>">
<input type="hidden" name="cftype[<?php echo $no;?>]" value="<?php echo $val['data_type'];?>">
<?php switch($val['data_type']){
	case 'text':
?>
<textarea name="cfvalue[<?php echo $no;?>]"><?php echo $val['value'];?></textarea>
<?php
	break;
	case 'single':
?>
<input type="checkbox" value="1" name="cfvalue[<?php echo $no;?>]" <?php echo $val['value']?'checked':'';?>>
<?php
	break;
	case 'file':
?>
<textarea name="cfvalue[<?php echo $no;?>]" id="cfvalue[<?php echo $no;?>]"><?php echo getAttachmentUrl($val['value']);?></textarea> <a href="<?php echo getAttachmentUrl($val['value']);?>"><?php echo getAttachmentUrl($val['value']);?></a> <input type="button" value="<?php _e('Replace');?>" class="replaceFile" data="<?php echo $no;?>">
<?php
	break;
	case 'html':
?>
<textarea name="cfvalue[<?php echo $no;?>]" id="cfvalue[<?php echo $no;?>]"><?php echo toggle_attachment($val['value'],'dashboard');?></textarea>
<script type="text/javascript">
<!--
	editorEnable('cfvalue[<?php echo $no;?>]');
//-->
</script>
<?php
	break;
}?>
</fieldset></li>
<?php
	}
	if($cfdata && !count($cf_rows)){
		$no = 0;
		$cfdata = unserialize($cfdata['content']);
		foreach($cfdata as $key=>$val){
				$no += 1;
?>
<li id="cf_<?php echo $no;?>">
<fieldset><legend><?php _e('Name');?> <input type="text" name="cfname[<?php echo $no;?>]" value="<?php echo $val['name'];?>"> 
<input type="button" value="<?php _e('Delete');?>" class="cf_del" data="<?php echo $no;?>"></legend>
<input type="hidden" name="cftype[<?php echo $no;?>]" value="<?php echo $val['type'];?>">
<?php switch($val['type']){
	case 'text':
?>
<textarea name="cfvalue[<?php echo $no;?>]"></textarea>
<?php
	break;
	case 'single':
?>
<input type="checkbox" value="1" name="cfvalue[<?php echo $no;?>]">
<?php
	break;
	case 'file':
?>
<textarea id="cfvalue[<?php echo $no;?>]" name="cfvalue[<?php echo $no;?>]"></textarea> <input type="button" value="<?php _e('Replace');?>" class="replaceFile" data="<?php echo $no;?>">
<?php
	break;
	case 'html':
?>
<textarea name="cfvalue[<?php echo $no;?>]" id="cfvalue[<?php echo $no;?>]"></textarea>
<script type="text/javascript">
<!--
	editorEnable('cfvalue[<?php echo $no;?>]');
//-->
</script>
<?php
	break;
}?>
</fieldset></li>
<?php
		}
	}
?>
</ol>
<div class="div_clear"></div>
<input type="hidden" id="cfno" name="cfno" data="<?php echo intval($no);?>"<?php echo !count($cf_rows)?'':' value="'.intval($no).'"';?>/>
<div class="mg5">
<select id="cftype">
	<option value="text"><?php _e('Text');?></option>
	<option value="single"><?php _e('Single');?></option>
	<option value="html"><?php _e('HTML');?></option>
	<option value="file"><?php _e('Files');?></option>
</select> 
<input type="button" value="<?php _e('Add Custom Field');?>" class="cf_add"> <input type="button" value="<?php echo _e('Clean Custom Field');?>" class="cf_clean"> <div><?php _e('One name & one value,these data will be listed by function get_custom_field,if you choose "save to field list",new item form will show this field');?></div></div>
</div>
</fieldset>
<script type="text/javascript">
<!--
	var cfno = <?php echo intval($no);?>,attach_media;
	_().ready(function(){
		_('.toggle').bind('click',function(){
			if (!_('#cfno').val())
			{
				_('#cfno').val(_('#cfno').attr('data'));
			}else{
				_('#cfno').val(0);
			}
		});
		_('.cf_clean').bind('click',function(){
			for (var i = 1; i <= parseInt(_('#cfno').attr('data')) ;i++ ){
				_('#cf_' + i).remove();
			}
		});
		_('.cf_add').bind('click',function(){
			cfno += 1;
			_('#cfno').val(cfno);
			_('#cfno').attr('data',cfno);
			var new_rule = document.createElement('li');
			var value_html;
			switch (_('#cftype').val())
			{
				case 'text':
					value_html = '<textarea name="cfvalue['+cfno+']"></textarea>';
				break;
				case 'single':
						value_html = '<input type="checkbox" name="cfvalue['+cfno+']" value="1"/>';
				break;
				case 'file':
						value_html = '<textarea name="cfvalue['+cfno+']" id="cfvalue['+cfno+']"></textarea> <input type="button" value="<?php _e('Replace');?>" class="replaceFile" data="'+cfno+'">';
				break;
				case 'html':
					value_html = '<textarea name="cfvalue['+cfno+']" id="cfvalue['+cfno+']"></textarea>';
				break;
			}
			_(new_rule).attr('id','cf_'+cfno).html('<fieldset><legend><?php _e('Name');?> <input type="text" name="cfname['+cfno+']" size="30"><?php if(!$savelist_none):?> <?php _e('Save to list');?> <input type="checkbox" value="1" name="savelist['+cfno+']"><?php endif;?> <input type="button" value="<?php _e('Delete');?>" class="cf_del" id="cf_'+cfno+'" data="'+cfno+'"><input type="hidden" name="cftype['+cfno+']" value="'+_('#cftype').val()+'"></legend>' + value_html + '</fieldset>');
			_('#cfList').append(new_rule);
			_('.cf_del').unbind('click').bind('click',function(){
				var no = _(this).attr('data');
				_('#cf_'+no).remove();
			});

			_('.replaceFile').unbind('click').bind('click',function(event){
				attach_media = _('#cfvalue['+_(this).attr('data')+']');
				_.dialog({'content':'<iframe id="media_body" src="./?type=media&referrer=attachment"></iframe>','title':'Choose file','name':'media','width':800,'height':500,'layer':true});
			});
			if (_('#cftype').val() == 'html'){
				editorEnable('cfvalue['+cfno+']');
			}
			if (_('#cftype').val() == 'file')
			{
				attach_media = _('#cfvalue['+cfno+']');
				_.dialog({'content':'<iframe id="media_body" src="./?type=media&referrer=attachment"></iframe>','title':'Choose file','name':'media','width':800,'height':500,'layer':true});
			}
		});

		_('.cf_del').bind('click',function(){
			var no = _(this).attr('data');
			_('#cf_'+no).remove();
		});
		
		_('.replaceFile').bind('click',function(event){
			attach_media = _('#cfvalue['+_(this).attr('data')+']');
			_.dialog({'content':'<iframe id="media_body" src="./?type=media&referrer=attachment"></iframe>','title':'Choose file','name':'media','width':800,'height':500,'layer':true});
		});
	});
//-->
</script>