<?php
/**
 * Template Name:Sidebar section template.
 *
 * @package SweetRice
 * @Mobile template
 * @since 0.5.4
 */
	defined('VALID_INCLUDE') or die();
	$category_list = getCategoryPosts($global_setting['nums_setting']['postCategories']);
	$uncategory_list = getUncategoryPosts($global_setting['nums_setting']['postUnCategories']);
	$t = getTagLists($global_setting['nums_setting']['tags']);
?>
<div id="sidebar_body">
<div id="float_nav"><span>&laquo; <?php _e('Navigation');?></span></div>
<div id="sidebar">
<div id="menu">
	<h4><?php _e('Uncategory');?></h4>		
	<div class="entry_list">
		<ul>
		<li><a href="<?php echo BASE_URL;?>"><?php _e('Home');?></a></li>
		<li><a href="<?php echo show_link_sitemapHtml();?>"><?php _e('Sitemap');?></a></li>
		<?php
			if(count($uncategory_list)):
				foreach($uncategory_list as $post_row):?>
			<li><a href="<?php echo show_link_page('',$post_row['sys_name']);?>"><?php echo $post_row['name'];?></a></li>
		<?php endforeach;?>
		<?php endif;?>
		</ul>
	</div>
<?php
	foreach($category_list as $val):
	for($i=0; $i<$val['category_level']; $i++):
		$prefix_nav .= '-- ';
	endfor;
?>
<h4><a href="<?php echo show_link_cat($categories[$val['category_id']]['link'],'');?>"><?php echo $prefix_nav.$categories[$val['category_id']]['name'];?></a> (<?php echo $val['total_post'];?>)</h4>
<div class="entry_list">
<?php if(is_array($val['post_rows'])):?>
<ul>
<?php 
	foreach($val['post_rows'] as $post_row):?>
	<li><a href="<?php echo show_link_page($categories[$post_row['category']]['link'],$post_row['sys_name']);?>"><?php echo $post_row['name'];?></a></li>
<?php endforeach;?>
</ul>
<?php endif;?>
</div>
<?php endforeach;?>

<?php if(count($t)):?>
<h4><?php _e('Tag');?></h4>
<div class="tags">
<?php
	$taglist = array();
	foreach($t as $ts):
		$tags = explode(',',$ts['tags']);
		foreach($tags as $val):
			$val = trim($val);
			if($val&&!in_array($val,$taglist)):
				$tmp = strlen($val)%5;
?>
<a href="<?php echo show_link_tag($val);?>"><?php echo $tmp==1?'<span class="tags_big">'.$val.'</span>':($tmp==2?'<span class="tags_middle">'.$val.'</span>':$val);?></a> 
<?php
				$taglist[] = $val;
			endif;
		endforeach;
	endforeach;
?>
</div>
<?php endif;?>

<?php if($links['content']):?>
<h4><?php _e('Links');?></h4>
<div id="links">
<?php echo $links['content'];?>
</div>
<?php endif;?>
</div>
</div>
</div>
<script type="text/javascript">
<!--
_().ready(function(){
	_('#float_nav').bind('click',function(){
		_('#sidebar').toggle();
		_('#menu').toggle();
	});
});
var sidebar_timer = null;
_(window).bind('scroll',function(){
	window.clearTimeout(sidebar_timer);
	var top = _.scrollSize().top == 0?_('#navbar').position().top:((_.pageSize().windowHeight-450)/2+_.scrollSize().top);		
	sidebar_timer = setTimeout(function(){_('#sidebar_body').animate({'top':top+'px'},1000,null,function(a,b,c,d){
		return parseFloat(a + (b - a) * Math.sin(parseFloat(c/d,10)*Math.PI/2),10);
	});},100);
});
//-->
</script>