<?php
/**
 * Plugin management.
 *
 * @package SweetRice
 * @Dashboard core
 * @since 0.5.4
 */
 defined('VALID_INCLUDE') or die();
 $plugin_list = pluginList();
 if(!$plugin_list[$plugin]['name']){
		alert(INVALID_PLUGIN,'./?type=plugins');
 }
 $plugin_directory = $plugin_list[$plugin]['directory'];
if($mode == 'install'){
	$optionRow = getOption('plugin_installed');
	$plugin_installed = unserialize($optionRow['content']);
	if($plugin_installed[$plugin]){
		alert(PLUGIN_EXISTS,'./?type=plugins');
	}
	if($plugin_directory && file_exists(SITE_HOME.'_plugin/'.$plugin_directory.'/plugin_config.php')){
		include(SITE_HOME.'_plugin/'.$plugin_directory.'/plugin_config.php');
		if(DATABASE_TYPE == 'sqlite'){
			if($plugin_config['install_sqlite']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['install_sqlite']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}elseif(DATABASE_TYPE == 'pgsql'){
			if($plugin_config['install_pgsql']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['install_pgsql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}else{
			if($plugin_config['install_sql']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['install_sql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}					
		}
		if($sql){
			foreach($sql as $key=>$val){
				if(trim($val)){
					$error = db_query(trim($val));
					if($error){
						$message .= $error.'<br>';
					}
				}
			}					
		}
		if(!$message){
			$plugin_installed[$plugin_config["name"]] = time();
			setOption('plugin_installed',serialize($plugin_installed));
			alert(vsprintf(PLUGIN_INSTALLED,array($plugin_config["name"])),'./?type=plugins');
		}else{
			echo $message;
		}
	}
}elseif($mode == 'deinstall'){
	if($plugin_directory && file_exists(SITE_HOME.'_plugin/'.$plugin_directory.'/plugin_config.php')){
		include(SITE_HOME.'_plugin/'.$plugin_directory.'/plugin_config.php');
		if(DATABASE_TYPE == 'sqlite'){
			if($plugin_config['deinstall_sqlite']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['deinstall_sqlite']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}elseif(DATABASE_TYPE == 'pgsql'){
			if($plugin_config['deinstall_pgsql']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['deinstall_pgsql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}else{
			if($plugin_config['deinstall_sql']){
				$sql = file_get_contents(SITE_HOME.'_plugin/'.$plugin_directory.'/'.$plugin_config['deinstall_sql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}
		if($sql){
			foreach($sql as $key=>$val){
				if(trim($val)){
					$error = db_query(trim($val));
					if($error){
						$message .= $error.'<br>';
					}
				}
			}
		}
		if(!$message){
			$plugin_old = $plugin_installed = array();
			$optionRow = getOption('plugin_installed');
			if($optionRow['content']){
				$plugin_old = unserialize($optionRow['content']);
			}
			foreach($plugin_old as $k=>$v){
				if($k != $plugin_config["name"]){
					$plugin_installed[$k] = $v;
				}
			}
			setOption('plugin_installed',serialize($plugin_installed));	
			alert(vsprintf(PLUGIN_DEINSTALLED,array($plugin_config["name"])),'./?type=plugins');
		}else{
			echo $message;
		}
	}
}
?>