<?php
/**
 * Initialize SweetRice.
 *
 * @package SweetRice
 * @since 1.2.5
 */
	error_reporting(E_ALL ^ E_NOTICE ^ E_USER_NOTICE);
	session_name('sweetrice');
	session_start();
	define('VALID_INCLUDE',true);
	define('INCLUDE_DIR',dirname(__FILE__).'/');
	if(file_exists(INCLUDE_DIR."setting.php")){
		include(INCLUDE_DIR."setting.php");
	}
	if(!$dashboard_dir){
		$dashboard_dir = 'as';	
	}
	define('DASHBOARD_DIR',$dashboard_dir);
	define('BASE_URL','http://'.$_SERVER["HTTP_HOST"].str_replace('//','/',dirname(str_replace('/'.DASHBOARD_DIR,'',$_SERVER["PHP_SELF"])).'/'));
	define('ROOT_DIR',substr(INCLUDE_DIR,0,-4));
	if(file_exists(INCLUDE_DIR."site.php")){
		include(INCLUDE_DIR."site.php");
	}
	if(file_exists(INCLUDE_DIR."db.php")){
		include(INCLUDE_DIR."db.php");
	}
	define('DB_LEFT',$db_left);
	define('DB_LEFT_PLUGIN',DB_LEFT.'_plugin');
	define('DATABASE_TYPE',$database_type);
	$db_left_plugin = DB_LEFT_PLUGIN;
	include(INCLUDE_DIR."function.php");
	switch(DATABASE_TYPE){
		case 'sqlite':
			$dbname = INCLUDE_DIR.$db_name.'.db';
			$db = sqlite_dbhandle($dbname);
		break;
		case 'pgsql':
			$conn  = pg_connect("host=".$db_url." port=".$db_port." dbname=".$db_name." user=".$db_username." password=".$db_passwd);
		break;
		case 'mysql':
		$conn     = mysql_connect($db_url.':'.$db_port,$db_username,$db_passwd);
		mysql_select_db($db_name,$conn);
		break;
	}
	if(file_exists(INCLUDE_DIR.'install.lock.php')){
		define('INSTALLED',true);
		$global_setting = db_array("SELECT `content`,`date` FROM `".DB_LEFT."_options` WHERE `name` = 'global_setting'");
		define('SETTING_UPDATE',$global_setting['date']);
		$global_setting = unserialize(clean_quotes($global_setting['content']));
		$categories_data = db_array("SELECT `content`,`date` FROM `".DB_LEFT."_options` WHERE `name` = 'categories'");
		define('CATEGORIES_UPDATE',$categories_data['date']);
		if($categories_data['content']){
			$categories_data = unserialize($categories_data['content']);
			foreach($categories_data as $val){
				if($val['id']){
					$categories[$val['id']] = $val;
					$categoriesByLink[$val['link']] = $val['id'];			
				}
			}
		}
	}
	if($global_setting['timeZone']){
		date_default_timezone_set($global_setting['timeZone']);
	}
	define('THEME_DIR',($global_setting['theme']?'_themes/'.$global_setting['theme'].'/':''));
	$theme_dir = THEME_DIR;
	if(file_exists(INCLUDE_DIR.'permalinks.php')){
		include(INCLUDE_DIR.'permalinks.php');		
	}else{
		$permalinks = initPermalinks();
	}
	define('ATTACHMENT_DIR','attachment/');
	define('LANG_DIR',INCLUDE_DIR.'lang/');
	$sweetrice_version = file_get_contents(INCLUDE_DIR.'lastest.txt');
?>