<?php
/**
 * Plugin management.
 *
 * @package SweetRice
 * @Dashboard core
 * @since 0.5.4
 */
 defined('VALID_INCLUDE') or die();
if($mode == 'install'){
	if(file_exists('../_plugin/'.$plugin.'/plugin_config.php')){
		include('../_plugin/'.$plugin.'/plugin_config.php');
		if(DATABASE_TYPE=='sqlite'){
			if($plugin_config['install_sqlite']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['install_sqlite']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}elseif(DATABASE_TYPE=='pgsql'){
			if($plugin_config['install_pgsql']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['install_pgsql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}
		}else{
			if($plugin_config['install_sql']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['install_sql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}					
		}
		if($sql){
			foreach($sql as $key=>$val){
				if(trim($val)){
					$error = db_query(trim($val));
					if($error)
					{
						$message .= $error.'<br>';
					}
				}
			}					
		}
		if(!$message){
			file_put_contents('../_plugin/'.$plugin.'/install.lock','install at '.date('H:i:s m-d-Y'));
			alert($plugin_config["name"].' has been installed successfully.');
			_goto('./?type=plugins');
		}else{
			echo $message;
		}
	}
}elseif($mode == 'deinstall'){
	if(file_exists('../_plugin/'.$plugin.'/plugin_config.php')){
		include('../_plugin/'.$plugin.'/plugin_config.php');
		if(DATABASE_TYPE=='sqlite'){
			if($plugin_config['deinstall_sqlite']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['deinstall_sqlite']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}					
		}elseif(DATABASE_TYPE=='pgsql'){
			if($plugin_config['deinstall_pgsql']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['deinstall_pgsql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}					
		}else{
			if($plugin_config['deinstall_sql']){
				$sql = file_get_contents('../_plugin/'.$plugin.'/'.$plugin_config['deinstall_sql']);
				$sql = str_replace('%--%',DB_LEFT_PLUGIN,$sql);
				$sql = explode(';',$sql);
			}					
		}
		if($sql){
			foreach($sql as $key=>$val){
				if(trim($val)){
					$error = db_query(trim($val));
					if($error){
						$message .= $error.'<br>';
					}
				}
			}					
		}
		if(!$message){
			@unlink('../_plugin/'.$plugin.'/install.lock');
			alert($plugin_config["name"].' has been deinstalled successfully.');
			_goto('./?type=plugins');
		}else{
			echo $message;
		}
	}
}
?>