<?php
/**
 * Database management template.
 *
 * @package SweetRice
 * @Dashboard core
 * @since 0.7.0
 */
 defined('VALID_INCLUDE') or die();
 $mode = $_GET["mode"];
 if($mode=='db_backup'){
		$form_mode = $_GET["form_mode"];
		$table_list = db_list();
		if($form_mode=='yes'){
			switch($database_type){
				case 'sqlite':
					include('lib/sqlite_backup.php');
				break;
				case 'pgsql':
					include('lib/pgsql_backup.php');
				break;
				case 'mysql':
					include('lib/mysql_backup.php');
				break;
			}
			alert(DATABASE_BAKUP_OK);
			_goto('./?type=data&mode=db_import');
		}
		$top_word = DATABACKUP;
		$inc = 'db_backup.php';
 }elseif($mode=='db_converter'){
		$datatypes = array('sqlite','mysql','pgsql');
		$form_mode = $_GET["form_mode"];
		$table_list = db_list();
		if($form_mode=='yes'){
			$totype = $_POST["totype"];
			switch($totype){
				case 'sqlite':
						include("lib/db_to_sqlite.php");
				break;
				case 'mysql':
						include("lib/db_to_mysql.php");
				break;
				case 'pgsql':
						include("lib/db_to_pgsql.php");
				break;
			}
		}
		if(!$totype){
			$totype = 'sqlite';
		}
		$s_totype[$totype] = 'selected';
		$top_word = DATACONVERTER;
		$inc = 'db_converter.php';
 }elseif($mode=='db_import'){
		$db_file = $_GET["db_file"];
		$form_mode = $_GET["form_mode"];
		if($database_type=='pgsql'){
			$db_backup_dir = 'lib/pgsql_backup';
			if($db_file&&file_exists($db_backup_dir.'/'.$db_file)&&$form_mode=='import'){
				$sql = file_get_contents($db_backup_dir.'/'.$db_file);
				$sql = str_replace('%--%',DB_LEFT,$sql);
				db_query($sql);
				$import_error = pg_last_error();
				$import = true;
			}
		}elseif($database_type=='sqlite'){
			$db_backup_dir = 'lib/sqlite_backup';			if($db_file&&file_exists($db_backup_dir.'/'.$db_file)&&$form_mode=='import'){
				$contents = file_get_contents($db_backup_dir.'/'.$db_file);
				$length = substr($contents,0,strpos($contents,'|'));
				$sqlLength = explode('|',substr($contents,strlen($length),$length));
				$sqldata = substr($contents,strlen($length) + $length);
				$total = count($sqlLength);
				for($i=1; $i<$total; $i++){
					$sql = substr($sqldata,0,$sqlLength[$i]);
					$sql = str_replace('%--%',DB_LEFT,$sql);
					$sqldata = substr($sqldata,$sqlLength[$i]);
					$import_error .= db_query($sql);
				}
				$import = true;
			}
		}else{
			$db_backup_dir = 'lib/mysql_backup';
			if($db_file&&file_exists($db_backup_dir.'/'.$db_file)&&$form_mode=='import'){
				$contents = file_get_contents($db_backup_dir.'/'.$db_file);
				$length = substr($contents,0,strpos($contents,'|'));
				$sqlLength = explode('|',substr($contents,strlen($length),$length));
				$sqldata = substr($contents,strlen($length) + $length);
				$total = count($sqlLength);
				for($i=1; $i<$total; $i++){
					$sql = substr($sqldata,0,$sqlLength[$i]);
					$sql = str_replace('%--%',DB_LEFT,$sql);
					$sqldata = substr($sqldata,$sqlLength[$i]);
					$import_error .= db_query($sql);
				}
				$import = true;
			}
		}
		if($form_mode=='delete'){
			$db_file = js_unescape($_POST["db_file"]);
			$no = $_POST["no"];
			if(file_exists($db_backup_dir.'/'.$db_file)){
				unlink($db_backup_dir.'/'.$db_file);
				echo($db_file.'|'.DATABACKUP.'|Successfully'.'|'.$no);
				exit();
			}else{
				echo($db_file.'|'.DATABACKUP.'|'.DATABACKUP.' not exists'.'|'.$no);
				exit();
			}
		}elseif($form_mode == 'bulk'){
			$plist = $_POST["plist"];
			foreach($plist as $val){
				if(file_exists($db_backup_dir.'/'.$val)){
					unlink($db_backup_dir.'/'.$val);
				}
			}
			_goto($_SERVER["HTTP_REFERER"]);
		}elseif($form_mode=='save'&&file_exists($db_backup_dir.'/'.$db_file)){
			$data = file_get_contents($db_backup_dir.'/'.$db_file);
			ob_end_clean();
			header('Content-Encoding: none');
			header('Content-Type: '.(strpos($HTTP_SERVER_VARS['HTTP_USER_AGENT'], 'MSIE') ? 'application/octetstream' : 'application/octet-stream'));
			header('Content-Disposition: '.(strpos($HTTP_SERVER_VARS['HTTP_USER_AGENT'], 'MSIE') ? 'inline; ' : 'attachment; ').'filename="'.$db_file);
			header('Content-Length: '.strlen($data));
			header('Pragma: no-cache');
			header('Expires: 0');
			die($data);
		}
		$top_word = DATAIMPORT;
		$inc = 'db_import.php';		
 }elseif($mode=='db_optimizer'){
	$form_mode = $_GET["form_mode"];
		$table_list = db_list();
		if($form_mode=='yes'){
			switch($database_type){
				case 'sqlite':
					foreach($table_list as $val){
						if(!db_query("vacuum ".$val)){
							$message .= $val." - ".OPTIMIZE_SUCCESSFULLY.".<br />";
						}else{
							$message .= $val." - ".OPTIMIZE_FAILED.".<br />";
						}
					}
				break;
				case 'pgsql':
					foreach($table_list as $val){
						if(!db_query("vacuum analyze ".$val)){
							$message .= $val." - ".OPTIMIZE_SUCCESSFULLY.".<br />";
						}else{
							$message .= $val." - ".OPTIMIZE_FAILED.".<br />";
						}
					}
				break;
				case 'mysql':
					foreach($table_list as $val){
						if(!db_query("optimize table ".$val)){
							$message .= $val." - ".OPTIMIZE_SUCCESSFULLY.".<br />";
						}else{
							$message .= $val." - ".OPTIMIZE_FAILED.".<br />";
						}
					}
				break;
			}
		}
		$top_word = DATAOPTIMIZER;
		$inc = 'db_optimizer.php';
 }
 ?>