<?php
/**
 * Initialize SweetRice.
 *
 * @package SweetRice
 * @since 1.2.5
 */
	error_reporting(E_ALL ^ E_NOTICE ^ E_USER_NOTICE);
	session_name('sweetrice');
	session_start();
	define('VALID_INCLUDE',true);
	define('INCLUDE_DIR',dirname(__FILE__).'/');
	if(file_exists(INCLUDE_DIR."setting.php"))
	{
		include(INCLUDE_DIR."setting.php");
	}
	if(!$dashboard_dir)
	{
		$dashboard_dir = 'as';	
	}
	$base_url = 'http://'.$_SERVER["HTTP_HOST"].str_replace('//','/',dirname(str_replace('/'.$dashboard_dir,'',$_SERVER["PHP_SELF"])).'/');
	$root_dir = substr(INCLUDE_DIR,0,-4);
	if(file_exists(INCLUDE_DIR."site.php"))
	{
		include(INCLUDE_DIR."site.php");
	}
	if(file_exists(INCLUDE_DIR."db.php"))
	{
		include(INCLUDE_DIR."db.php");
	}
	include(INCLUDE_DIR."function.php");
	switch($database_type)
	{
		case 'sqlite':
			$dbname = INCLUDE_DIR.$db_name.'.db';
			$db = sqlite_dbhandle($dbname);
		break;
		case 'pgsql':
			$conn  = pg_connect("host=".$db_url." port=".$db_port." dbname=".$db_name." user=".$db_username." password=".$db_passwd);
		break;
		case 'mysql':
		$conn     = mysql_connect($db_url.':'.$db_port,$db_username,$db_passwd);
		mysql_select_db($db_name,$conn);
		break;
	}	
	if(file_exists(INCLUDE_DIR.'install.lock.php'))
	{
		define('INSTALLED',true);
		$global_setting = db_array("SELECT `content`,`date` FROM `".$db_left."_options` WHERE `name` = 'global_setting'");
		define('SETTING_UPDATE',$global_setting['date']);
		$global_setting = unserialize($global_setting['content']);
		$categories_data = db_array("SELECT `content`,`date` FROM `".$db_left."_options` WHERE `name` = 'categories'");
		define('CATEGORIES_UPDATE',$categories_data['date']);
		if($categories_data['content'])
		{
			$categories_data = unserialize($categories_data['content']);
			foreach($categories_data as $val)
			{
				if($val['id'])
				{
					$categories[$val['id']] = $val;
					$categoriesByLink[$val['link']] = $val['id'];			
				}
			}
		}
	}
	$theme_dir = $global_setting['theme']?'_themes/'.$global_setting['theme'].'/':'';
	$theme_ = file($root_dir.($theme_dir?$theme_dir:'inc/').'theme.config');
	$page_theme = get_page_themes($theme_);
	if(file_exists(INCLUDE_DIR.'permalinks.php'))
	{
		include(INCLUDE_DIR.'permalinks.php');		
	}else
	{
		$permalinks = initPermalinks();
	}
	define('ATTACHMENT_DIR','attachment/');
	$db_left_plugin = $db_left.'_plugin';
	$sweetrice_version = file_get_contents(INCLUDE_DIR.'lastest.txt');
?>