DROP TABLE IF EXISTS "%--%_attachment";
CREATE TABLE  "%--%_attachment" (
  "id" serial,
  "post_id" int NOT NULL,
  "file_name" varchar(255) NOT NULL,
  "date" int NOT NULL,
  "downloads" int NOT NULL,
  PRIMARY KEY  ("id")
);
DROP TABLE IF EXISTS "%--%_comment";
CREATE TABLE  "%--%_comment" (
  "id" serial,
  "name" varchar(60) NOT NULL default '',
  "email" varchar(255) NOT NULL default '',
  "website" varchar(255) NOT NULL ,
  "info" text NOT NULL,
  "post_id" int NOT NULL default '0',
  "post_name" varchar(255) NOT NULL,
  "post_cat" varchar(128) NOT NULL,
  "post_slug" varchar(128) NOT NULL,
  "date" int NOT NULL default '0',
  "ip" varchar(39) NOT NULL default '',
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "%--%_posts";
CREATE TABLE  "%--%_posts" (
  "id" serial,
  "name" varchar(256) NOT NULL,
  "title" varchar(256) NOT NULL,
  "body" text NOT NULL,
  "keyword" varchar(255) NOT NULL default '',
  "tags" text NOT NULL,
  "description" varchar(255) NOT NULL default '',
  "sys_name" varchar(128) NOT NULL UNIQUE,
  "date" int NOT NULL default '0',
  "category" int NOT NULL default '0',
  "in_blog" int NOT NULL,
  "views" int NOT NULL,
  "allow_comment" int NOT NULL default '1',
  "template" varchar(60) NOT NULL,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "%--%_category";
CREATE TABLE  "%--%_category" (
  "id" serial,
  "name" varchar(256) NOT NULL,
  "link" varchar(128) NOT NULL UNIQUE,
  "title" text NOT NULL,
  "description" varchar(255) NOT NULL,
  "keyword" varchar(255) NOT NULL,
  "sort_word" text NOT NULL,
  "parent_id" int NOT NULL default '0',
  "template" varchar(60) NOT NULL,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "%--%_blog";
CREATE TABLE  "%--%_blog" (
  "id" serial,
  "name" varchar(255) NOT NULL,
  "author" varchar(60) NOT NULL,
  "title" varchar(255) NOT NULL,
  "keywords" text NOT NULL,
  "description" varchar(255) NOT NULL,
  "database_type" varchar(20) NOT NULL,
  "db_url" varchar(255) NOT NULL,
  "db_port" int NOT NULL,
  "db_name" varchar(80) NOT NULL,
  "db_username" varchar(128) NOT NULL,
  "db_passwd" varchar(128) NOT NULL,
  "db_left" varchar(20) NOT NULL,
  "admin" varchar(128) NOT NULL,
  "passwd" char(32) NOT NULL,
  "close" int NOT NULL,
  "close_tip" text NOT NULL,
  "cache" int NOT NULL,
  "cache_expired" int NOT NULL,
  "user_track" int NOT NULL,
  "url_rewrite" int NOT NULL,
  "logo" varchar(255) NOT NULL,
  "theme" varchar(255) NOT NULL,
  "lang" varchar(80) NOT NULL,
  "admin_email" varchar(255) NOT NULL,
  PRIMARY KEY  ("id")
);