<?php
/**
 * All function.
 *
 * @package SweetRice
 * @SweetRice core.
 * @since 0.5.4
 */
	defined('VALID_INCLUDE') or die();
	function do_data($a,$filterData)
	{
		foreach($a as $key=>$val)
		{
			if(!is_array($val))
			{
				switch($filterData)
				{
					case 'public':
						$a[$key] = db_escape(trim(clean_quotes($val)));
					break;
					case 'privacy':
						$a[$key] = trim(clean_quotes($val));
					break;
				}
			}
		}
		return $a;
	}
	function escape_string($str)
	{
		return htmlspecialchars(db_unescape($str),ENT_QUOTES);
	}
	function clean_quotes($str)
	{
		if(get_magic_quotes_gpc())
		{
			$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
		}
		return $str;
	}
	function db_escape($str)
	{
		global $database_type;
		switch($database_type)
		{
			case 'sqlite':
				return sqlite_escape_string($str);
			break;
			case 'pgsql':
				return addslashes($str);
			break;
			default:
				return addslashes($str);
		}
	}
	function db_unescape($str)
	{
		global $database_type;
		switch($database_type)
		{
			case 'sqlite':
				return str_replace('\'\'','\'',$str);
			break;
			case 'pgsql':
				$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
				return $str;
			break;
			default:
				$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
				return $str;
		}
	}
	if (!function_exists('htmlspecialchars_decode')) {
		function htmlspecialchars_decode($str,$quote_style)
		{
			$_str = array('&amp;','&quot;','&#039;','&lt;','&gt;');
			$str_ = array('&','"','\'','<','>');
			return str_replace($_str,$str_,$str);
		}
	}
	function initPermalinks(){
		$permalinks['attachment'] = 'download';
		$permalinks['rssfeed'] = 'rssfeed';
		$permalinks['rssfeedCat'] = 'cat_rssfeed';
		$permalinks['rssfeedPost'] = 'rssfeed';
		$permalinks['sitemapXml'] = 'sitemap';
		$permalinks['sitemapHtml'] = 'sitemap';
		$permalinks['comment'] = 'comment';
		$permalinks['tag'] = 'tags';
		$permalinks['ad'] = 'ads';
		return $permalinks;
	}
	//init Url data to SweetRice.
	function initUrl($url)
	{
		global $permalinks,$dashboard_dir,$root_dir;
		$urlRedirect = array();
		if(file_exists($root_dir.'inc/url_redirect.txt'))
		{
			$redirect_contents = file($root_dir.'inc/url_redirect.txt');
			foreach($redirect_contents as $val)
			{
				$val = trim($val);
				if($val)
				{
					$tmp = explode('->',$val);
					$urlRedirect[trim($tmp[0])] = trim($tmp[1]);
				}
			}			
		}
		$url_data = array();
		if($urlRedirect[$url])
		{
			_301($urlRedirect[$url]);
		}elseif(preg_match("/^".$permalinks['attachment']."\/([0-9]+)\/$/",$url,$matches))
		{
			$url_data['action'] = 'attachment';
			$url_data['id'] = $matches[1];
		}elseif(preg_match("/^".$permalinks['ad']."\/([a-z0-9A-Z-_]+)\.js$/",$url,$matches))
		{
			$url_data['action'] = 'ads';
			$url_data['adname'] = $matches[1];
		}elseif($url==$permalinks['rssfeed'].'.xml')
		{
			$url_data['action'] = 'rssfeed';
		}elseif(preg_match("/^".$permalinks['rssfeedCat']."\/([a-zA-Z0-9\-_]+)\.xml$/",$url,$matches))
		{
			$url_data['action'] = 'rssfeed';
			$url_data['type'] = 'category';
			$url_data['c'] = $matches[1];
		}elseif(preg_match("/^".$permalinks['rssfeedPost']."\/([a-zA-Z0-9\-_]+)\.xml$/",$url,$matches))
		{
			$url_data['action'] = 'rssfeed';
			$url_data['type'] = 'entry';
			$url_data['post'] = $matches[1];
		}elseif($url==$permalinks['sitemapXml'].'.xml')
		{
			$url_data['action'] = 'sitemap';
			$url_data['type'] = 'xml';
		}elseif($url==$permalinks['sitemapHtml'].'/')
		{
			$url_data['action'] = 'sitemap';
		}elseif(preg_match("/^".$permalinks['comment']."\/([a-zA-Z0-9\-_]+)\/(([0-9]{0,3})\/)?$/",$url,$matches))
		{
			$url_data['action'] = 'comment';
			$url_data['post'] = $matches[1];
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^".$permalinks['tag']."\/([^\/]+)\/(([0-9]{0,3})\/)?$/",$url,$matches))
		{
			$url_data['action'] = 'tags';
			$url_data['tag'] = rawurldecode($matches[1]);
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\.html$/",$url,$matches))
		{
			$url_data['action'] = 'entry';
			$url_data['post'] = $matches[1];
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\/(([0-9]{0,3})\/)?$/",$url,$matches))
		{
			$url_data['action'] = 'category';
			$url_data['c'] = $matches[1];
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\/([a-zA-Z0-9\-_]+)\/$/",$url,$matches))
		{
			$url_data['action'] = 'entry';
			$url_data['cateName'] = $matches[1];
			$url_data['post'] = $matches[2];
		}elseif(substr($url,0,4)=='inc/'||substr($url,0,strlen($dashboard_dir)+5)==$dashboard_dir.'/lib/')
		{
			$url_data['action'] = 'Forbidden';
		}elseif($url)
		{
			$prefix = end(explode('/',$url));
			if(strpos($prefix,'.'))
			{
				$url_data['rtype'] = 'wp';
			}else
			{
				$url_data['rtype'] = 'wop';
			}
			$url_data['action'] = 'Unknow';
		}
		return $url_data;
	}
	function show_link_ads($adname)
	{
		global $url_rewrite;
		if($url_rewrite)
		{
			global $permalinks;
			return $permalinks['ad'].'/'.$adname.'.js';
		}else
		{
			return '?action=ads&adname='.$adname;
		}
	}
	function show_link_page($cat_link,$post){
		global $url_rewrite;
		if($url_rewrite)
		{
			if($cat_link)
			{
				return $cat_link.'/'.$post.'/';
			}else
			{
				return $post.'.html';
			}
		}else
		{
			return '?action=entry&post='.$post;
		}
	}
	function show_link_page_xml($post){
		global $url_rewrite;
		if($url_rewrite)
		{
			global $permalinks;
			return $permalinks['rssfeedPost'].'/'.$post.'.xml';
		}else
		{
			return '?action=rssfeed&type=entry&post='.$post;
		}
	}
	function show_link_cat($category,$p='')
	{
		global $url_rewrite;
		if($url_rewrite)
		{
			return $category.'/'.($p>1?$p.'/':'');
		}else
		{
			return '?action=category&c='.$category.($p>1?'&p='.$p:'');
		}
	}
	function show_link_cat_xml($category)
	{
		global $url_rewrite;
		if($url_rewrite)
		{
			global $permalinks;
			return $permalinks['rssfeedCat'].'/'.$category.'.xml';
		}else
		{
			return '?action=rssfeed&type=category&c='.$category;
		}
	}
	function show_link_tag($tag)
	{
		global $url_rewrite;
		if($url_rewrite)
		{
			global $permalinks;
			return $permalinks['tag'].'/'.rawurlencode($tag).'/'.($p>0?$p.'/':'');
		}else
		{
			return '?action=tags&tag='.rawurlencode($tag).($p>1?'&p='.$p:'');
		}
	}
	function show_link_comment($post,$p)
	{
		global $url_rewrite;
		if($url_rewrite)
		{
			global $permalinks;
			return $permalinks['comment'].'/'.$post.'/'.($p>1?$p.'/':'');
		}else
		{
			return '?action=comment&post='.$post.($p>1?'&p='.$p:'');
		}
	}
	function show_link_attachment($fileID)
	{
		global $url_rewrite;
		global $permalinks;
		if($url_rewrite)
		{
			return $permalinks['attachment'].'/'.$fileID.'/';
		}else
		{
			return '?action=attachment&id='.$fileID;
		}
	}
	function show_link_sitemapHtml()
	{
		global $url_rewrite;
		global $permalinks;
		if($url_rewrite)
		{
			return $permalinks['sitemapHtml'].'/';
		}else
		{
			return '?action=sitemap';
		}
	}
	function show_link_sitemapXml()
	{
		global $url_rewrite;
		global $permalinks;
		if($url_rewrite)
		{
			return $permalinks['sitemapXml'].'.xml';
		}else
		{
			return '?action=sitemap&type=xml';
		}
	}
	function show_link_rssfeed()
	{
		global $url_rewrite;
		global $permalinks;
		if($url_rewrite)
		{
			return $permalinks['rssfeed'].'.xml';
		}else
		{
			return '?action=rssfeed';
		}
	}
	function postPreview($content)
	{
		preg_match_all("/.*(<p ?.*>(.+)<\/p>)+.*/",$content,$matchs);
		foreach($matchs[1] as $key=>$val)
		{
			if($val!='<p>&nbsp;</p>'&&$val!='<p></p>')
			{
				preg_match("/<p ?[^>]*>(.+)<\/p>/",$val,$out);
				$previewContent = $out[1];
				break;
			}
		}
		if(!$previewContent)
		{
			$previewContent = mb_substr(strip_tags($content),0,300,'UTF-8');
		}
		return $previewContent;
	}
	if(!function_exists('mb_substr'))
	{
		function mb_substr($str,$start,$len,$charcode)
		{
			$str_len = strlen($str);
			$tmpstr = "";
			for($i = 0; $i < $start; $i++){
				 if(ord(substr($str, $i, 1)) > 127){
					 if(ord(substr($str, $i, 2)) > 127)
					 {
						$i += 2;
					 }else
					 {
						$i++;
					 }					
				 }
			}
			$start = $i;
			$strlen = ($start + $len)>$str_len?$str_len:($start + $len);
			for($i = $start; $i < $strlen; $i++){
				 if(ord(substr($str, $i, 1)) > 127){
					 if(ord(substr($str, $i, 2)) > 127)
					 {
						$tmpstr .= substr($str, $i, 3);
						$i += 2;
					 }else
					 {
						$tmpstr .= substr($str, $i, 2);
						$i++;
					 }					
				 }else
					$tmpstr .= substr($str, $i, 1);
			}
			return $tmpstr;
		}
	}
	function checkemail($email)
	{
		$email = strtolower($email);
		return preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]*\.)+[a-zA-Z]{2,3}$/",$email);
	}
	function my_post($to,$subject,$mail_text,$mail_html,$from_mail,$from_name,$mime_boundary,$charset = 'UTF-8')
	{
		$from_name = '=?'.$charset.'?B?'.base64_encode($from_name).'?=';
		$subject = '=?'.$charset.'?B?'.base64_encode($subject).'?=';
		$headers = "From: ".$from_name." <".$from_mail.">\n";
		$headers .= "MIME-Version: 1.0\n";
		$headers .= "Content-Type: multipart/alternative; boundary=\"$mime_boundary\"\n";
		$message = "--$mime_boundary\n";
		$message .= "Content-Type: text/plain; charset=".$charset."\n";
		$message .= "Content-Transfer-Encoding: 8bit\n\n";
		$message .= $mail_text;
		$message .= "\n\n";
		$message .= "--$mime_boundary\n";
		$message .= "Content-Type: text/html; charset=".$charset."\n";
		$message .= "Content-Transfer-Encoding: 8bit\n\n";
		$message .= $mail_html;
		$message .= "\n";
		$message .= "--$mime_boundary--\n\n";
		$mail_sent = mail( $to, $subject, $message, $headers );
		return $mail_sent;
	}
	function js_unescape($str)
	{
			$ret = '';
			$len = strlen($str);
			for ($i = 0; $i < $len; $i++)
			{
					if ($str[$i] == '%' && $str[$i+1] == 'u')
					{
							$val = hexdec(substr($str, $i+2, 4));
							if ($val < 0x7f) $ret .= chr($val);
							else if($val < 0x800) $ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f));
							else $ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f));
							$i += 5;
					}
					else if ($str[$i] == '%')
					{
							$ret .= urldecode(substr($str, $i, 3));
							$i += 2;
					}
					else $ret .= $str[$i];
			}
			return $ret;
	}
	function sweetrice_cache($cache_link,$data,$cache_type)
	{
		global $root_dir,$cache,$cache_expired;
		if($cache)
		{
			if(!file_exists($root_dir.'inc/cache/'))
			{
				mkdir($root_dir.'inc/cache/',0777);
			}
			if(!file_exists($root_dir.'inc/cache/'.$cache_link)||(time()-filemtime($root_dir.'inc/cache/'.$cache_link)>$cache_expired&&$cache_expired!=0))
			{
				$cache_data = '';
				switch($cache_type)
				{
					case 'db_array':
						if(is_array($data))
						{
							foreach($data as $key=>$val)
							{
								$cache_data .= $key.'^'.rawurlencode($val).'|';
							}							
						}
					break;
					case 'db_arrays':
						foreach($data as $val)
						{
							foreach($val as $_key=>$_val)
							{
								$cache_data .= $_key.'^'.rawurlencode($_val).'|';
							}
							$cache_data .= '#';
						}
					break;
					case 'db_total':
						$cache_data = $data;
					break;
				}
				file_put_contents($root_dir.'inc/cache/'.$cache_link,$cache_data);
				return ;
			}
		}else
		{
			return ;
		}
	}
	function sweetrice_cached($cache_link,$cache_type)
	{
		global $root_dir,$cache,$cache_expired;
		if($cache)
		{
			if(file_exists($root_dir.'inc/cache/'.$cache_link)&&(time()-@filemtime($root_dir.'inc/cache/'.$cache_link)<=$cache_expired||$cache_expired==0))
			{
				$cache_data = file_get_contents($root_dir.'inc/cache/'.$cache_link);
				switch($cache_type)
				{
					case 'db_array':
						$cache_data = explode('|',$cache_data);
						foreach($cache_data as $val)
						{
							if(trim($val))
							{
								$tmp = explode('^',$val);
								$row[$tmp[0]] = rawurldecode($tmp[1]);
							}
						}
						return $row;
					break;
					case 'db_arrays':
						$cache_data = explode('#',$cache_data);
						foreach($cache_data as $val)
						{
							if(trim($val))
							{
								$_row = array();
								$tmp = explode('|',$val);
								foreach($tmp as $_val)
								{
									if(trim($_val))
									{
										$_tmp = explode('^',$_val);
										$_row[$_tmp[0]] = rawurldecode($_tmp[1]);
									}
								}
								$row[] = $_row;
							}
						}
						return $row;
					break;
					case 'db_total':
						return $cache_data;
					break;	
				}
			}else
			{
				return false;
			}
		}else
		{
			return false;
		}
	}
	function db_insert($table,$_id,$_key,$_val,$return_no=false)
	{
		$_id[1] = intval($_id[1]);
		global $database_type;
		switch($database_type)
		{
			case 'sqlite':
				$_key = '"'.implode('","',$_key).'"';
				$_val = "'".implode("','",$_val)."'";
				if($_id[0]&&$_id[1]>0)
				{
					$sql = "REPLACE INTO \"".$table."\" (\"".$_id[0]."\",".$_key.")VALUES('".$_id[1]."',".$_val.")";
				}elseif($_id[0])
				{
					$sql = "REPLACE INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES(NULL,".$_val.")";
				}else
				{
					$sql = "REPLACE INTO \"".$table."\"(".$_key.")VALUES(".$_val.")";
				}
				global $db;
				return sqlite_dbinsert($db,$sql,$_id[0]);
			break;
			case 'pgsql':
			global $cache;
			$cache = false;
				if($_id[0]&&$_id[1]>0)
				{
					$total = db_total("SELECT COUNT(*) FROM \"".$table."\" WHERE \"".$_id[0]."\" = '".$_id[1]."'");
					if($total==1)
					{
						$_sql = " SET ";
						for($i=0; $i<count($_key); $i++)
						{
							if($i==0)
							{
								$_sql .= " \"".$_key[$i]."\" = '".$_val[$i]."' ";
							}else
							{
								$_sql .= " , \"".$_key[$i]."\" = '".$_val[$i]."' ";
							}
						}
						$sql = "UPDATE \"".$table."\" ".$_sql." WHERE \"".$_id[0]."\" = '".$_id[1]."'";
					}else
					{
						$_key = '"'.implode('","',$_key).'"';
						$_val = "'".implode("','",$_val)."'";
						$sql = "INSERT INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES('".$_id[1]."',".$_val.")";	
					}
					pg_query($sql);
					return $_id[1];
				}else
				{
					$_key = '"'.implode('","',$_key).'"';
					$_val = "'".implode("','",$_val)."'";
					if($_id[0])
					{
						$last_id = db_array("SELECT \"".$_id[0]."\" FROM \"".$table."\" ORDER BY \"".$_id[0]."\" DESC LIMIT 1 ");
						$last_id = $last_id[$_id[0]] + 1;
						$sql = "INSERT INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES('$last_id',".$_val.")";	
					}else
					{
						$tindex = db_array("SELECT pg_constraint.conname AS pk_name,pg_attribute.attname AS colname FROM pg_constraint INNER JOIN pg_class ON pg_constraint.conrelid = pg_class.oid INNER JOIN pg_attribute ON pg_attribute.attrelid = pg_class.oid AND pg_attribute.attnum = pg_constraint.conkey[1] WHERE pg_class.relname = '".$table."' AND pg_constraint.contype='p'");
						if($tindex['colname'])
						{
							$n_key = array_flip($_key);
							$nindex = $n_key[$tindex['colname']];
							$total = db_total("SELECT COUNT(*) FROM \"$table\" WHERE \"".$tindex['colname']."\" = '".$_val[$nindex]."'");
							if($total)
							{
								$_sql = " SET ";
								for($i=0; $i<count($_key); $i++)
								{
									if($i==0)
									{
										$_sql .= " \"".$_key[$i]."\" = '".$_val[$i]."' ";
									}else
									{
										$_sql .= " , \"".$_key[$i]."\" = '".$_val[$i]."' ";
									}
								}
								$sql = "UPDATE \"".$table."\" ".$_sql." WHERE \"".$tindex['colname']."\" = '".$_val[$nindex]."'";
							}else
							{
								$sql = "INSERT INTO \"".$table."\"(".$p_key.")VALUES(".$p_val.")";
							}
						}else
						{
							$sql = "INSERT INTO \"".$table."\"(".$p_key.")VALUES(".$p_val.")";
						}
					}
					pg_query($sql);
					if(!$return_no&&$_id[0])
					{
						$row = db_array("SELECT \"".$_id[0]."\" FROM \"".$table."\" ORDER BY \"".$_id[0]."\" DESC LIMIT 1 ");
						return $row[$_id[0]];
					}else
					{
						return true;
					}
				}
			break;
			default:
				$_key = '`'.implode('`,`',$_key).'`';
				$_val = "'".implode("','",$_val)."'";
				if($_id[0])
				{
					$sql = "REPLACE INTO `".$table."`(`".$_id[0]."`,".$_key.")VALUES('".$_id[1]."',".$_val.")";
				}else
				{
					$sql = "REPLACE INTO `".$table."`(".$_key.")VALUES(".$_val.")";
				}
				mysql_query($sql);
				if($_id[0])
				{
					return mysql_insert_id();
				}else
				{
					return true;
				}
		}
	}
	function db_query($sql)
	{
		global $database_type;
		switch($database_type)
		{
			case 'sqlite':
				$sql = str_replace('`','"',$sql);
				global $db;
				return sqlite_dbquery($db,$sql);
			break;
			case 'pgsql':
				$sql = str_replace('`','"',$sql);
				$res = pg_query($sql);
				return pg_last_error();
			break;
			default:
				mysql_query($sql);
				return mysql_error();
		}
	}
	function db_arrays($sql,$type = 'ASSOC')
	{
		$cache_link = 'db_arrays_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_arrays');
		if($cache_data)
		{
			return $cache_data;
		}else
		{
			$rows = array();
			global $database_type;
			switch($database_type)
			{
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$rows = sqlite_dbarrays($db,$sql,$type);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$res = pg_query($sql);
					while($row = pg_fetch_array($res,null,$type=='BOTH'?PGSQL_BOTH:PGSQL_ASSOC))
					{
						$rows[] = $row;
					}
				break;
				default:
					$res = mysql_query($sql);
					while($row = mysql_fetch_array($res,$type=='BOTH'?MYSQL_BOTH:MYSQL_ASSOC))
					{
						$rows[] = $row;
					}
			}
			sweetrice_cache($cache_link,$rows,'db_arrays');
			return $rows;
		}
	}
	function db_array($sql,$type = 'ASSOC')
	{
		$cache_link = 'db_array_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_array');
		if($cache_data)
		{
			return $cache_data;
		}else
		{
			$row = array();
			global $database_type;
			switch($database_type)
			{
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$row = sqlite_dbarray($db,$sql,$type);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$row = pg_fetch_array(pg_query($sql),null,$type=='BOTH'?PGSQL_BOTH:PGSQL_ASSOC);
				break;
				default:
					$row = mysql_fetch_array(mysql_query($sql),$type=='BOTH'?MYSQL_BOTH:MYSQL_ASSOC);
			}
			sweetrice_cache($cache_link,$row,'db_array');
			return $row;
		}
	}
	function db_total($sql)
	{
		$cache_link = 'db_total_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_total');
		if($cache_data)
		{
			return $cache_data;
		}else
		{
			global $database_type;
			switch($database_type)
			{
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$total = sqlite_dbtotal($db,$sql);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$row = pg_fetch_row(pg_query($sql));
					$total = $row[0];
				break;
				default:
					$row = mysql_fetch_row(mysql_query($sql));
					$total = $row[0];
			}
			sweetrice_cache($cache_link,$total,'db_total');
			return $total;			
		}
	}
	function sqlite_dbhandle($dbname)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			$db = sqlite_open($dbname);
		}else
		{
			if(!file_exists($dbname))
			{
				$handle = fopen($dbname,'w+');
				fclose($handle);
			}
			$db = new PDO('sqlite:'.$dbname);
		}
		return $db;
	}
	function sqlite_dbinsert($db,$sql,$id)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			sqlite_query($db,$sql);
			if($id)
			{
				return sqlite_last_insert_rowid($db);
			}else
			{
				return true;
			}
		}else
		{			
			$db->query($sql);
			if($id)
			{
				return $db->lastInsertId();
			}else
			{
				return true;
			}

		}
	}
	function sqlite_dbquery($db,$sql)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			sqlite_query($db,$sql,null,$error);
			if($error)
			{
				return $error;
			}else
			{
				return '';
			}			
		}else
		{
			$db->query($sql);
			$error = $db->errorInfo();
			if($error[0]!='0000')
			{
				return $error[2];
			}else
			{
				return '';
			}
		}
	}
	function sqlite_dbarray($db,$sql,$type)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			return clean_dbData(sqlite_fetch_array(sqlite_query($db,$sql),$type=='BOTH'?SQLITE_BOTH:SQLITE_ASSOC));			
		}else
		{
			$row = $db->query($sql)->fetchAll($type=='BOTH'?SQLITE_BOTH:PDO::FETCH_ASSOC);
			return $row[0];
		}
	}
	function sqlite_dbarrays($db,$sql,$type=null)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			$res = sqlite_query($db,$sql);
			while($row = sqlite_fetch_array($res,$type=='BOTH'?SQLITE_BOTH:SQLITE_ASSOC))
			{
				$rows[] = clean_dbData($row);
			}
		}else
		{
			$rows = $db->query($sql)->fetchAll($type=='BOTH'?SQLITE_BOTH:PDO::FETCH_ASSOC);
		}
		return $rows;
	}
	function sqlite_dbtotal($db,$sql)
	{
		global $sqlite_driver;
		if($sqlite_driver=='sqlite')
		{
			$row = sqlite_fetch_array(sqlite_query($db,$sql));
			return $row[0];
		}else
		{
			$row = $db->query($sql)->fetchAll();
			$total = $row[0][0];	
			return $total;			
		}
	}
	function clean_dbData($row)
	{
		if(!$row)
		{
			$row = array();
		}
		foreach($row as $key=>$val)
		{
			$row[trim($key,'"')] = $val;
		}
		return $row;
	}
	function db_list()
	{
		global $database_type,$db_left;
		switch($database_type)
		{
			case 'sqlite':
					$table_array = db_arrays("select name from sqlite_master where name LIKE '".$db_left.'_'."%' AND name NOT LIKE 'sqlite_%'",'BOTH');
					foreach($table_array as $val)
					{
						if(substr($val[0],0,(strlen($db_left)+1))==$db_left.'_')
						{
							$table_list[] = $val[0];
						}
					}
			break;
			case 'mysql':
					$table_array = db_arrays("SHOW TABLES",'BOTH');
					foreach($table_array as $val)
					{
						if(substr($val[0],0,(strlen($db_left)+1))==$db_left.'_')
						{
							$table_list[] = $val[0];
						}
					}
			break;
			case 'pgsql':
					$table_array = db_arrays("SELECT tablename FROM pg_tables  WHERE tablename LIKE '".$db_left."_%' ;");
					foreach($table_array as $val)
					{
						if(substr($val['tablename'],0,(strlen($db_left)+1))==$db_left.'_')
						{
							$table_list[] = $val['tablename'];
						}
					}
			break;
		}
		return $table_list;
	}
	function _out()
	{
		if(!headers_sent()&&extension_loaded("zlib")&&strpos($_SERVER["HTTP_ACCEPT_ENCODING"],"gzip")!==false)
		{
			ob_start(ob_start("ob_gzhandler"));
		}else
		{
			ob_start();
		}
	}
	function _flush()
	{
		ob_end_flush();
	}
	function upload_($f,$dest_dir,$new_file,$old_file)
	{
		$file_type = '.php';
		$fileext = '.'.end(explode('.',$f['name']));
		if(preg_match("/[^a-zA-Z0-9_\-\.\s]+/",$new_file))
		{
			$new_file  = md5($new_file).$fileext;
		}
		if($f['name']&&strtolower($fileext)!=$file_type)
		{
			$dest=$dest_dir.$new_file;
			$r=move_uploaded_file($f['tmp_name'],$dest);
			if($old_file&&file_exists($dest_dir.$old_file)&&$old_file!=$new_file)
			{
				unlink($dest_dir.$old_file);
			}
			return $new_file;
		}else
		{
			return $old_file;
		}
	}
	function subCategory($sql='',$id=0,$level=0)
	{
		$subCategorys = array();
		global $db_left;
		$row = db_arrays("SELECT `id` FROM `".$db_left."_category` WHERE `parent_id` = '$id'".$sql);
		foreach($row as $val)
		{
			$val['level'] = $level;
			$subCategorys[] = $val;
			$subCategorys = array_merge ($subCategorys,subCategory($sql,$val['id'],$level+1));
		}
		return $subCategorys;
	}
	
	function mod_date($d)
	{
		if(!$d)
		{
			$d = time();
		}
		if(intval(phpversion())>=5)
		{
			$mod_date = date('c',$d);
		}else
		{
			$mod_date = date('Y-m-d',$d).'T'.date('HisO',$d);
		}
		return $mod_date;
	}
	function init_browsers($t=1)
	{
		$browsers = array('MSIE 10.0','MSIE 9.0','MSIE 8.0','MSIE 7.0','MSIE 6.0','Firefox','Opera','Chrome','Safari','Google','Yahoo','Bing','Baidu','Other');
		$bg_browsers = array('#2800fc','#2896fc','#286ea2','#285880','#0a9682','#ee7907','#e11625','#6aa0c8','#63b143','#009900','#ff11dd','#FF9900','#6655ff','#648282');
		if($t==2)
		{
			return $bg_browsers;
		}else
		{
			return $browsers;
		}
	}
	function user_track()
	{
		$ip = getenv("REMOTE_ADDR");
		$user_from = $_SERVER["HTTP_REFERER"];
		$this_page = $_SERVER["REQUEST_URI"];
		$user_browser = $_SERVER["HTTP_USER_AGENT"];
		$browsers = init_browsers(1);
		foreach($browsers as $val)
		{
			if(strpos(strtoupper($user_browser),strtoupper($val))!==false)
			{
				$user_browser = $val;
				$is_browser = true;
				break;
			}
		}
		if(!$is_browser)
		{
			$user_browser = 'Other';
		}
		
		if($user_from=='')
		{
			$user_from = 'Directly access';
		}
		$dbname = 'inc/user_track.db';
		if(!file_exists($dbname))
		{
			$new_track = true;
		}
		$db_track = sqlite_dbhandle($dbname);
		if($new_track)
		{
			sqlite_dbquery($db_track,"CREATE TABLE user_agent (id INTEGER PRIMARY KEY ,ip varchar(39) ,user_from varchar(255) ,this_page varchar(255),user_browser varchar(255),time integer)");
			sqlite_dbquery($db_track,"CREATE TABLE agent_month (id INTEGER PRIMARY KEY ,user_browser varchar(255),record_date date,total int(10),UNIQUE(user_browser,record_date))");
		}
		sqlite_dbquery($db_track,"INSERT INTO user_agent (id,ip,user_from,this_page,user_browser,time)VALUES(NULL,'$ip','$user_from','$this_page','$user_browser','".time()."')");
		return ;
	}
	function get_limit_sql($page_start,$page_limit)
	{
		global $database_type;
		if($database_type=='pgsql')
		{
			return "LIMIT $page_limit OFFSET $page_start";
		}else
		{
			return "LIMIT $page_start , $page_limit ";
		}
	}
	function get_page_themes($theme)
	{
		foreach($theme as $key=>$val)
		{
			if(trim($val))
			{
				$tmp = explode('|',$val);
				$page_theme[trim($tmp[0])] = trim($tmp[1]);
			}
		}
		return $page_theme;
	}
 function filesize2print($filename)
	{
		global $base_url,$root_dir;
		if(substr($filename,0,strlen($base_url))!=$base_url)
		{
			return 'Remote file';
		}
		$filename = str_replace($base_url,$root_dir,$filename);
		$fs = filesize($filename);
		if($fs>1073741824)
		{
			return number_format(($fs/1073741824),2,'.','').'G';
		}elseif($fs>1048576)
		{
			return number_format(($fs/1048576),2,'.','').'M';
		}elseif($fs>1024)
		{
			return number_format(($fs/1024),2,'.','').'k';
		}else
		{
			return $fs.'B';
		}
	}
	function filterXMLContent($content)
	{
		$content = preg_replace("/[^(\x20-\x7f)]*/",'',$content);
		return $content;
	}
	function _404($tip_404)
	{
		global $base_url,$site_name;
		header('HTTP/1.1 404 Page Not Found');
		$tip_404s = array('category'=>'Sorry ,the category does not exists.','entry'=>'Sorry ,the entry does not exists.','attachment'=>'Sorry ,the attachment does not exists.','tags'=>'Sorry ,the tag does not exists.','plugin'=>'Sorry ,the plugin does not exists.','home'=>'Invalid request,please check your url.');
		include("inc/404.php");
		exit();
	}
	function _403()
	{
		header("HTTP/1.1 403 Forbidden"); 
		die('<!DOCTYPE html>
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Access Forbidden</h1>
<p>You don\'t have permission to access this page.</p>
</body></html>');
	}
	function _301($url)
	{
		header('HTTP/1.1 301 Moved Permanently'); 
		header('Location: '.$url); 
		exit();
	}
	function _304($last_access,$etag,$Expires)
	{
		header('Cache-Control: public,must-revalidate');
		header('Expires: '.gmdate('D, d M Y H:i:s', $Expires).' GMT');
		header('Last-Modified:'.gmdate('D, d M Y H:i:s', $last_access).' GMT', true, 304);
		if($etag)
		{
			header('Etag:'.$etag,true,304);
		}
		exit(0);
	}
	function _200($last_modify,$etag,$Expires)
	{
		header('Cache-Control: public,must-revalidate');
		header('Expires: '.gmdate('D, d M Y H:i:s', $Expires).' GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', $last_modify).' GMT', true, 200);
		if($etag)
		{
			header('Etag:'.$etag,true,200);
		}
	}
	function outputHeader($last_modify,$etag='',$ExpiresDate=0)
	{
		$last_access = $_SERVER['HTTP_IF_MODIFIED_SINCE']?strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']):0;
		$last_etag = $_SERVER['HTTP_IF_NONE_MATCH'];
		$Expires = $last_modify + $ExpiresDate;
		$Expires = $Expires>time()?$Expires:time();
		if($etag&&$last_etag!=$etag)
		{
			_200($last_modify,$etag,$Expires);
		}elseif(($last_modify>0&&$last_modify <= $last_access)||($etag&&$last_etag==$etag)){
			_304($last_access,$etag,$Expires);
		}else
		{
			_200($last_modify,$etag,$Expires);
		}
	}
	function pushDate($row)
	{
		$last_modifys = array(0);
		foreach($row as $val)
		{
			foreach($val as $k=>$v)
			{
				$last_modifys[] = $v['date'];
			}
		}
		return max($last_modifys);
	}
	function alert($str)
	{
?>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<script type="text/javascript">
<!--
	alert('<?php echo $str;?>');
//-->
</script>
<?php
	}
	function _goto($url)
	{
?>
<script type="text/javascript">
<!--
	location.href = '<?php echo $url;?>';
//-->
</script>
<?php
	exit();
	}
?>
