<?php
/**
 * Site management template.
 *
 * @package SweetRice
 * @Dashboard core
 * @since 0.5.4
 */
 defined('VALID_INCLUDE') or die();
?>
<form method="post" action="./?type=setting&mode=save" enctype="multipart/form-data">
<input type="hidden" name="old_passwd" value="<?php echo $site_passwd;?>"/>
<input type="hidden" name="old_logo" value="<?php echo $site_logo;?>"/>
<fieldset><legend><?php echo SITE_NAME;?></legend>
<input type="text" name="name" value="<?php echo $site_name;?>">
</fieldset>
<fieldset><legend>Logo</legend>
<img src="../images/<?php echo $site_logo?$site_logo:'sweetrice.jpg';?>">
<input type="file" name="logo" class="input_text_tip" > <?php echo MAX_UPLOAD_FILE_TIP,':',UPLOAD_MAX_FILESIZE;?></fieldset>
<fieldset><legend><?php echo THEME;?></legend>
<select name="theme">
	<option value="" selected="selected"><?php echo DEFAULT_TIP;?></option>
<?php
	foreach($themes as $val)
	{
?>
<option value="<?php echo $val;?>" <?php echo $s_theme[trim($val)];?> ><?php echo $val;?></option>
<?php
	}	
?>
</select></fieldset>
<fieldset><legend><?php echo LANG;?></legend>
<select name="lang">
	<option value="" ><?php echo DEFAULT_TIP;?></option>
<?php
	foreach($lang as $key=>$val)
	{
?>
<option value="<?php echo $val;?>" <?php echo $s_lang[trim($val)];?> ><?php echo $key;?></option>
<?php
	}
?>
</select></fieldset>
<fieldset><legend><?php echo WEBMASTER;?></legend>
<input type="text" name="author" value="<?php echo $author;?>"></fieldset>
<fieldset><legend><?php echo TITLE.'('.DEFAULT_TIP.')';?></legend>
<input type="text" name="title" class="input_text" value="<?php echo $site_title;?>"></fieldset>
<fieldset><legend><?php echo META.' '.SETTING;?></legend>
<ul>
<li><input type="text" name="keyword" class="input_text" value="<?php echo $site_keyword?$site_keyword:KEYWORD.'('.DEFAULT_TIP.')';?>" onblur="if (this.value == '') {this.value = '<?php echo KEYWORD.'('.DEFAULT_TIP.')';?>';}" onfocus="if (this.value == '<?php echo KEYWORD.'('.DEFAULT_TIP.')';?>') {this.value = '';}" > <?php echo KEYWORD.'('.DEFAULT_TIP.')';?></li>
<li><input type="text" name="description" class="input_text" value="<?php echo $site_description?$site_description:DESCRIPTION.'('.DEFAULT_TIP.')';?>" onblur="if (this.value == '') {this.value = '<?php echo DESCRIPTION.'('.DEFAULT_TIP.')';?>';}" onfocus="if (this.value == '<?php echo DESCRIPTION.'('.DEFAULT_TIP.')';?>') {this.value = '';}"> <?php echo DESCRIPTION.'('.DEFAULT_TIP.')';?></li>
</ul>
</fieldset>
<fieldset><legend><?php echo DASHBOARD_DIR;?></legend>
<input type="text" name="dashboard_dirs" value="<?php echo $dashboard_dir;?>"> <?php echo DASHBOARD_DIR_TIP;?>
</fieldset>
<fieldset><legend><?php echo DATABASE.' '.SETTING;?></legend>
<?php
	if($database_type=='sqlite')
	{
?>
<ul>
<li><?php echo DATABASE;?> : <input type="text" value="sqlite" name="database_type" readonly></li>
</ul>
<?php
	}else
	{
?>
<ul>
<li><?php echo DATABASE;?> : <input type="text" value="<?php echo $database_type?$database_type:'mysql';?>" name="database_type" readonly></li>
<li><?php echo DATABASE_HOST;?> : <input type="text" name="db_url" class="input_text_tip" value="<?php echo $db_url?$db_url:'localhost';?>" readonly> *<?php echo DATABASE_HOST_TIP;?></li>
<li><?php echo DATA_PORT;?> : <input type="text" name="db_port" class="input_text_tip" value="<?php echo $db_port;?>" readonly></li>
<li><?php echo DATA_ACCOUNT;?> : <input type="text" name="db_username" class="input_text_tip" value="<?php echo $db_username;?>" readonly></li>
<li><?php echo DATA_PASSWORD;?> : <input type="password" name="db_passwd" class="input_text_tip" value="<?php echo $db_passwd;?>" readonly></li>
</ul>
<?php
	}
?>
</fieldset>
<fieldset><legend><?php echo DATA_NAME;?></legend>
<input type="text" name="db_name" class="input_text_tip" value="<?php echo $db_name;?>" readonly></fieldset>
<fieldset><legend><?php echo DATA_PREFIX;?></legend>
<input type="text" name="db_left" class="input_text_tip" value="<?php echo $db_left;?>" readonly></fieldset>
<fieldset><legend><?php echo ADMIN_ACCOUNT;?></legend>
<input type="text" name="admin" value="<?php echo $site_admin;?>"></fieldset>
<fieldset><legend><?php echo ADMIN_PASSWORD;?></legend>
<input type="password" name="passwd"></fieldset>
<fieldset><legend><?php echo URL_REWRITE;?></legend>
<input type="checkbox" name="url_rewrite" value="1" <?php echo $url_rewrite?'checked':'';?>/> 
<?php echo NEED_SERVER_SUPPORT;?></fieldset>
<fieldset><legend><?php echo SITE_CLOSE_TIP;?></legend>
<p><label id="lbVisual" onmousedown='doEditor("visual","close_tip");'>Visual</label>
<label id="lbHtml" class="current_label" onmousedown='doEditor("html","close_tip");'>HTML</a></label></p>
<?php include("lib/tinymce.php");?>
<textarea id="close_tip" name="close_tip" class="input_textarea"><?php echo $site_close_tip;?></textarea>
<br /><?php echo SITE_CLOSE_TIPS;?>
</fieldset>
<fieldset><legend><?php echo SITE_CLOSE;?></legend>
<input type="checkbox" name="close" value="1" <?php echo $site_close?'checked':'';?>/>
</fieldset>
<fieldset><legend><?php echo CACHE;?></legend>
<input type="checkbox" name="cache" value="1" <?php echo $site_cache?'checked':'';?>/> <?php echo CACHE_TIPS;?>
</fieldset>
<fieldset><legend><?php echo CACHE.' '.EXPIRED;?></legend>
<input type="text" name="cache_expired" value="<?php echo $cache_expired;?>"/> <?php echo S;?>
</fieldset>
<fieldset><legend><?php echo TRACK;?></legend>
<input type="checkbox" name="user_track" value="1" <?php echo $user_track?'checked':'';?>/>
</fieldset>
<fieldset><legend><?php echo ADMIN_EMAIL;?></legend>
<input type="text" name="admin_email" value="<?php echo $admin_email;?>"/>
</fieldset>
<input type="submit" class="input_submit" value="<?php echo DONE;?>"> <input type="button" value="<?php echo BACK;?>" onclick='location.href="./"' class="input_submit">
</form>