<?php
/**
 * View user track.
 *
 * @package SweetRice
 * @Plugin subscriber
 * @since 0.5.4
 */
defined('VALID_INCLUDE') or die();
$dbname = '../inc/user_track.db';
$font_ttf = '../_plugin/font/arial.ttf';
if(file_exists($dbname))
{
	$y = $_GET["y"];
	if($y=='')
	{
		$y = date('Y');
	}
	$m = $_GET["m"];
	if($m=='')
	{
		$m = date('m');
	}
	$d = date('t',mktime(0,0,0,$m,1,$y));

	$today_start = mktime(0,0,0,$m,1,$y);
	$today_end = mktime(23,59,59,$m,$d,$y);
	$browsers = array('ie9'=>'MSIE 9.0','ie8'=>'MSIE 8.0','ie7'=>'MSIE 7.0','ie6'=>'MSIE 6.0','firefox'=>'Firefox','opera'=>'Opera','safari'=>'Safari','chrome'=>'Chrome','other'=>'Other');
	$db_track = sqlite_dbhandle($dbname);
	$results = sqlite_dbarrays($db_track,"SELECT * FROM user_agent WHERE time >= '$today_start' and time < '$today_end' ");

	$max_month = array();
	if($results)
	{
		foreach($results as $vals)
		{
			$this_day = intval(date('d',$vals['time']));
			$max_month[$this_day] +=1;
			foreach($browsers as $key=>$val)
			{
				if(strtolower($vals['user_browser'])==strtolower($val))
				{
					$total_browser[$key][$this_day] +=1;
					$total_all[$key] +=1;
					break;
				}
			}
		}
	}
	if(count($max_month)==0)
	{
		$no_data = true;
	}else
	{
		$max_y = max($max_month);
		$vv = $max_y/300;
		$x = 18;
		$padding_left = 30;
		$width = 6;
		$l_x = $x*$d+$padding_left+20;
		$total_ = count($results);
		foreach($browsers as $key=>$val)
		{
			$v[$key] = number_format($total_all[$key]*100/$total_ ,2,'.',' ').'%';
		}
		$im = imagecreate(120+$l_x,340);
		$bg = imagecolorallocate($im, 255, 255, 255);
		$black = imagecolorallocate($im, 0, 0, 0);
		$white = imagecolorallocate($im, 255, 255, 255);
		$font = imagecolorallocate($im, 120, 120, 120);
		$watermark = imagecolorallocate($im, 180, 240, 180);
		$bg_browser = array(
		'ie9'=>imagecolorallocate($im, 40, 150, 252),
		'ie8'=>imagecolorallocate($im, 40, 110, 162),
		'ie7'=>imagecolorallocate($im, 40, 88, 128),
		'ie6'=>imagecolorallocate($im, 10, 150, 130),
		'firefox'=>imagecolorallocate($im, 238, 121, 7),
		'opera'=>imagecolorallocate($im, 225, 22, 37),
		'safari'=>imagecolorallocate($im, 106, 160, 200),
		'chrome'=>imagecolorallocate($im, 99, 177, 67),
		'other'=>imagecolorallocate($im, 100, 130, 130));

		imagettftext($im, 30, 15, 100, 220, $watermark, $font_ttf, 'Powered by SweetRice');
		$_rtop = 300;
		foreach($browsers as $key=>$val)
		{
			imagettftext($im, 11, 0, $l_x, $_rtop, $bg_browser[$key], $font_ttf,$val.':'.$v[$key]);
			$_rtop -= 30;
		}
		imagettftext($im, 11, 0, $l_x, $_rtop, $black, $font_ttf,$y.'-'.$m);

		$line_rotage = 0;
		$style = array($black, $white);
		imagesetstyle($im, $style);

		$s_line = 310;
		$no = 0;
		for($i=0; $i<8; $i++)
		{
			imageline ($im,$padding_left+$x-$width,$s_line,$x*$d+$padding_left+$width,$s_line,IMG_COLOR_STYLED);
			imagettftext($im, 7, 0, 0, ($s_line+10), $black, $font_ttf,round($no*50*$vv));
			$s_line -= 50;
			$no +=1;
		}
		for($i=1; $i<=$d; $i++)
		{
			imageline ($im,($i*$x+$padding_left),310,($i*$x+$padding_left),315,$font);
			imagettftext($im, 7, 0, ($i*$x+$padding_left), 326, $font, $font_ttf,$i);
			imagettftext($im, 7, 0, ($i*$x+$padding_left), 337, $black, $font_ttf,substr(date('l',mktime(0,0,0,$m,$i,$y)),0,2));

			$sh = $eh = 310;
			$last_sh = 0;
			foreach($browsers as $key=>$val)
			{
				$eh = $eh - ($total_browser[$key][$i]/$vv);
				$sh = $sh - $last_sh;
				imagefilledrectangle($im, ($i*$x+$padding_left-$width),$sh,($i*$x+$padding_left+$width),$eh,$bg_browser[$key]);
				$last_sh = $total_browser[$key][$i]/$vv;
			}
		}
	}
	
}else
{
	$no_data = true;
}
if($no_data)
{
	$im = imagecreate(380,100);
	$bg = imagecolorallocate($im, 128, 128, 128);
	$white = imagecolorallocate($im, 255, 255, 255);
	imagettftext($im, 12, 0, 20, 50, $white, $font_ttf,'No data,please enable User track or visit later.');
}
header('Content-type: image/png');
imagepng($im);
imagedestroy($im);
?>