DROP TABLE IF EXISTS `%--%_attachment`;
CREATE TABLE IF NOT EXISTS `%--%_attachment` (
  `id` int(10) NOT NULL auto_increment,
  `post_id` int(10) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `date` int(10) NOT NULL,
  `downloads` int(10) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

DROP TABLE IF EXISTS `%--%_comment`;
CREATE TABLE IF NOT EXISTS `%--%_comment` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `website` varchar(255) NOT NULL ,
  `info` text NOT NULL,
  `post_id` int(10) NOT NULL default '0',
  `post_name` varchar(255) NOT NULL,
  `post_cat` varchar(128) NOT NULL,
  `post_slug` varchar(128) NOT NULL,
  `date` int(10) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

DROP TABLE IF EXISTS `%--%_posts`;
CREATE TABLE IF NOT EXISTS `%--%_posts` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(256) NOT NULL,
  `title` varchar(256) NOT NULL,
  `body` longtext NOT NULL,
  `keyword` varchar(255) NOT NULL default '',
  `tags` text NOT NULL,
  `description` varchar(255) NOT NULL default '',
  `sys_name` varchar(128) NOT NULL,
  `date` int(10) NOT NULL default '0',
  `category` int(10) NOT NULL default '0',
  `in_blog` tinyint(1) NOT NULL,
  `views` int(10) NOT NULL,
  `allow_comment` tinyint(1) NOT NULL default '1',
  `template` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `sys_name` (`sys_name`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;


DROP TABLE IF EXISTS `%--%_category`;
CREATE TABLE IF NOT EXISTS `%--%_category` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(256) NOT NULL,
  `link` varchar(128) NOT NULL,
  `title` text NOT NULL,
  `description` varchar(255) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `sort_word` text NOT NULL,
  `parent_id` int(10) NOT NULL default '0',
  `template` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;



DROP TABLE IF EXISTS `%--%_blog`;
CREATE TABLE IF NOT EXISTS `%--%_blog` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `author` varchar(60) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` text NOT NULL,
  `description` varchar(255) NOT NULL,
  `database_type` varchar(20) NOT NULL,
  `db_url` varchar(255) NOT NULL,
  `db_port` int(10) ,
  `db_name` varchar(80) NOT NULL,
  `db_username` varchar(128) NOT NULL,
  `db_passwd` char(32) NOT NULL,
  `db_left` varchar(20) NOT NULL,
  `admin` varchar(128) NOT NULL,
  `passwd` char(32) NOT NULL,
  `close` tinyint(1) NOT NULL,
  `close_tip` text NOT NULL,
  `cache` tinyint(1) ,
  `cache_expired` int(10) ,
  `user_track` tinyint(1) NOT NULL,
  `url_rewrite` tinyint(1) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `theme` varchar(255) NOT NULL,
  `lang` varchar(80) NOT NULL,
  `admin_email` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;
