<?php
/**
 * SmipleAnalytics functions.
 *
 * @package SweetRice
 * @Plugin SmipleAnalytics
 * @since 1.0.0
 */
 defined('VALID_INCLUDE') or die();
function get_data_from_url($url)
	{
		$allow_url_fopen  = ini_get('allow_url_fopen');
		if($allow_url_fopen)
		{
			$output = file_get_contents($url);
		}else
		{
			
		$url = str_replace('http://','',$url);
		$urls = explode('/',$url);
		$url_str = substr($url,strlen($urls[0]));
			$fp = fsockopen($urls[0], 80, $errno, $errstr, 30);
			if (!$fp) {
					echo "$errstr ($errno)<br />\n";
			} else {
					$out = "GET ".$url_str." HTTP/1.1\r\n";
					$out .= "Host: ".$urls[0]."\r\n";
					$out .= "Connection: Close\r\n\r\n";
					fwrite($fp, $out);
					while (!feof($fp)) {
							$data .= fgets($fp, 1024);
					}
					fclose($fp);
			}
			preg_match("/\r\n\r\n(.+)/is", $data, $out);
			$output = $out[1];
		}
		return $output;
	}
 function Analytics($content)
 {
	 $size = strlen($content);
	 $content = preg_replace("/<!--\s*.*-->/iU","",html_entity_decode($content));
	 $result = array();
	 preg_match("/<title>(\s*)(.+)(\s*)<\/title>/i",$content,$match);
	 $title = $match[2];
	 preg_match_all("/<(\s*)meta(.+)\/?(\s*)>/i",$content,$match);
	 foreach($match[2] as $val)
	 {
		$lowval = strtolower($val);
		if(strpos($lowval,'name="keywords"')!==false || strpos($lowval,"name='keywords'")!==false || strpos($lowval,'name=keywords')!==false)
		{
			preg_match("/(\s*)content=('|\")?(.+)('|\")(\s*)(\/)?/i",$val,$vmatch);
			$keywords = strip_all($vmatch[3]);
		}elseif(strpos($lowval,'name="description"')!==false || strpos($lowval,"name='description'")!==false || strpos($lowval,'name=description')!==false)
		{
			preg_match("/(.*)content=('|\")?(.+)('|\")(\s*)(\/)?/i",$val,$vmatch);
			$description = strip_all($vmatch[3]);
		}
	 }
		preg_match_all("/<h1>\s*(.+)\s*<\/h1>/i",$content,$match);
		$h1s = $match[1];
		preg_match_all("/<h2>\s*(.+)\s*<\/h2>/i",$content,$match);
		$h2s = $match[1];
		preg_match_all("/<h3>\s*(.+)\s*<\/h3>/i",$content,$match);
		$h3s = $match[1];
		preg_match_all("/<h4>\s*(.+)\s*<\/h4>/i",$content,$match);
		$h4s = $match[1];
		preg_match_all("/<h5>\s*(.+)\s*<\/h5>/i",$content,$match);
		$h5s = $match[1];
		preg_match_all("/<h6>\s*(.+)\s*<\/h6>/i",$content,$match);
		$h6s = $match[1];
		$lc = preg_replace("/<a\s+[^>]+href='?\"?(.+)('|\")>(.+)<\/a>/iU","<a href=\$1\">\$3</a>",$content);
		preg_match_all("/<a href=('|\")(.+)('|\".*)>\s*([^>]+)\s*<\/a>/iU",$lc,$match);
		$as = array();
		foreach($match[2] as $key=>$val)
		{
			$as[$val] = trim($match[4][$key]);
		}
		preg_match_all("/<img\s+(.*)src=(.+)\/?>/iU",$content,$match);
		$imgs = $match[2];
		$body = strip_all($content);
		$ks = preg_split("/[^a-z0-9\-_\.']+/i",$body);
		$tmp_ks = array();
		foreach($ks as $val)
		{
			$val  = trim($val);
			if(!in_array($val,$tmp_ks)&&$val&&preg_match("/.*[a-z0-9]+.*/i",$val))
			{
				$tmp_ks[$val] +=1;
			}
		}
		arsort($tmp_ks);
		$result = array('base'=>$base,'size'=>$size,'title'=>$title,'keywords'=>$keywords,'description'=>$description,'h1s'=>$h1s,'h2s'=>$h2s,'h3s'=>$h3s,'h4s'=>$h4s,'h5s'=>$h5s,'h6s'=>$h6s,'as'=>$as,'imgs'=>$imgs,'body'=>$body,'tsize'=>strlen($body),'ks'=>$tmp_ks);
		return $result;
 }
 function strip_all($content)
 {
		$content = str_replace("\n",'',$content);
		$content = preg_replace("/<style\s*.*>.+<\/style>/iU","",$content);
		$content = preg_replace("/<script\s*.*>.*<\/script>/iU","",$content);
		$content = strip_tags($content);
		return $content;
 }
?>